SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: barang
#

DROP TABLE IF EXISTS `barang`;

CREATE TABLE `barang` (
  `id_barang` int(11) NOT NULL AUTO_INCREMENT,
  `kode_barang` varchar(10) DEFAULT NULL,
  `nama_barang` varchar(50) DEFAULT NULL,
  `harga` int(11) DEFAULT NULL,
  `stok` int(5) DEFAULT NULL,
  `foto_barang` varchar(100) DEFAULT NULL,
  `id_jenis` int(11) DEFAULT NULL,
  `id_merk` int(11) DEFAULT NULL,
  `kode_supplier` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id_barang`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: barang_keluar
#

DROP TABLE IF EXISTS `barang_keluar`;

CREATE TABLE `barang_keluar` (
  `id_barang_keluar` int(11) NOT NULL AUTO_INCREMENT,
  `kode_barang` varchar(20) DEFAULT NULL,
  `tgl_keluar` date DEFAULT NULL,
  `jumlah` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_barang_keluar`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: barang_masuk
#

DROP TABLE IF EXISTS `barang_masuk`;

CREATE TABLE `barang_masuk` (
  `id_barang_masuk` int(11) NOT NULL AUTO_INCREMENT,
  `kode_barang` varchar(10) DEFAULT NULL,
  `kode_supplier` varchar(10) DEFAULT NULL,
  `jumlah` int(3) DEFAULT NULL,
  `harga` int(10) DEFAULT NULL,
  PRIMARY KEY (`id_barang_masuk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: jenis_barang
#

DROP TABLE IF EXISTS `jenis_barang`;

CREATE TABLE `jenis_barang` (
  `id_jenis` int(11) NOT NULL AUTO_INCREMENT,
  `jenis_barang` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_jenis`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: merk_barang
#

DROP TABLE IF EXISTS `merk_barang`;

CREATE TABLE `merk_barang` (
  `id_merk` int(11) NOT NULL AUTO_INCREMENT,
  `merk_barang` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_merk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: mp_aset
#

DROP TABLE IF EXISTS `mp_aset`;

CREATE TABLE `mp_aset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_aset` varchar(128) NOT NULL,
  `tanggal_perolehan` date NOT NULL,
  `jumlah_unit` varchar(128) NOT NULL,
  `umur_manfaat` varchar(128) NOT NULL,
  `harga_perolehan` varchar(128) NOT NULL,
  `akumulasi_penyusutan` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# TABLE STRUCTURE FOR: mp_generalentry
#

DROP TABLE IF EXISTS `mp_generalentry`;

CREATE TABLE `mp_generalentry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `naration` varchar(255) CHARACTER SET latin1 NOT NULL,
  `generated_source` varchar(50) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: mp_head
#

DROP TABLE IF EXISTS `mp_head`;

CREATE TABLE `mp_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET latin1 NOT NULL,
  `nature` varchar(50) CHARACTER SET latin1 NOT NULL,
  `type` varchar(50) CHARACTER SET latin1 NOT NULL,
  `expense_type` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8;

INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (1, '[101010001] Bank BCA', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (2, '[101010002] Kas', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (3, '[101010003] Kas Kecil', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (4, '[101020001] Cek', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (5, '[101030001] Piutang Usaha', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (6, '[101040001] Alat Tulis Kantor', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (7, '[101040002] Persediaan Barang Habis Pakai', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (8, '[101050001] Asuransi Dibayar Dimuka', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (9, '[101050002] Pajak Dibayar Dimuka', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (10, '[101050003] Sewa Dibayar Dimuka', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (11, '[101060001] Persediaan Barang Dagang', 'Assets', '[101] Current Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (12, '[102010001] Peralatan Kantor', 'Assets', '[102] Fixed Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (13, '[102010002] Akumulasi Penyusutan Peralatan Kantor', 'Assets', '[102] Fixed Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (14, '[102010003] Tanah', 'Assets', '[102] Fixed Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (15, '[102010004] Akumulasi Penyusutan Tanah', 'Assets', '[102] Fixed Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (16, '[102010005] Gedung', 'Assets', '[102] Fixed Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (17, '[102010006] Akumulasi Penyusutan Gedung', 'Assets', '[102] Fixed Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (18, '[103010001] Reksa Dana Saham', 'Assets', '[103] Long Term Investment', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (19, '[104010001] Good Will', 'Assets', '[104] Intagible Fixed Assets', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (20, '[201010001] Utang Wesel', 'Liability', '[201] Current Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (21, '[201020001] Utang Usaha', 'Liability', '[201] Current Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (22, '[201030001] Utang Gaji', 'Liability', '[201] Current Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (23, '[201030002] Utang Bunga', 'Liability', '[201] Current Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (24, '[201030003] Biaya Masih Harus Dibayar', 'Liability', '[201] Current Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (25, '[201030004] Pendapatan Diterima Dimuka', 'Liability', '[201] Current Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (26, '[201030005] Utang Pajak', 'Liability', '[201] Current Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (27, '[202010001] Utang Bank', 'Liability', '[202] Long-term Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (28, '[202010002] Utang Obligasi', 'Liability', '[202] Long-term Liabilities', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (29, '[303010001] Modal Usaha', 'Equity', '[301] Modal', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (30, '[303010002] Dividen', 'Equity', '[301] Modal', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (31, '[303010003] Ikhtisar Laba Rugi', 'Equity', '[301] Modal', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (32, '[303020001] Laba Ditahan', 'Equity', '[302] Laba Ditahan', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (33, '[401010001] Pendapatan Honorarium / Jasa', 'Revenue', '[401] Pendapatan Usaha', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (34, '[401010002] Penjualan Barang', 'Revenue', '[401] Pendapatan Usaha', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (35, '[401010003] Diskon Penjualan', 'Revenue', '[401] Pendapatan Usaha', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (36, '[401010004] Retur Penjualan', 'Revenue', '[401] Pendapatan Usaha', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (37, '[402010001] Pendapatan Sewa', 'Revenue', '[402] Pendapatan Diluar Usaha', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (38, '[402010002] Penjualan Non Produk', 'Revenue', '[402] Pendapatan Diluar Usaha', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (39, '[501010001] Bunga Akrual', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (40, '[501010002] Pajak Akrual', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (41, '[501030001] Beban Gaji &amp; Upah', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (42, '[501030002] Beban Transportasi', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (43, '[501030003] Beban Alat Tulis Kantor', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (44, '[501030004] Beban Asuransi', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (45, '[501030005] Beban Listrik, Air, Telepon dan Internet', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (46, '[501030006] Beban Sewa', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (47, '[501030007] Beban Administrasi', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (48, '[501030008] Beban Iklan', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (49, '[501040001] Penyusutan Bangunan', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (50, '[501040002] Penyusutan Sewa Guna Usaha', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (51, '[501040003] Penyusutan Perlengkapan Kantor', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (52, '[501040004] Beban Barang Habis Pakai ', 'Expense', '[501] Beban Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (53, '[502010001] Beban Bunga Bank', 'Expense', '[502] Beban Diluar Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (54, '[502010002] Beban Administrasi Bank', 'Expense', '[502] Beban Diluar Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (55, '[502010003] Beban Pajak Penghasilan', 'Expense', '[502] Beban Diluar Usaha', NULL);
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (56, '[601010001] Persediaan Awal', 'HPP', '[601] Harga Pokok Penjualan', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (57, '[601010002] Persediaan Akhir ', 'HPP', '[601] Harga Pokok Penjualan', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (58, '[601010003] Pembelian Barang', 'HPP', '[601] Harga Pokok Penjualan', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (59, '[601010004] Diskon Pembelian ', 'HPP', '[601] Harga Pokok Penjualan', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (60, '[601010005] Retur Pembelian', 'HPP', '[601] Harga Pokok Penjualan', '-');
INSERT INTO `mp_head` (`id`, `name`, `nature`, `type`, `expense_type`) VALUES (61, '[601010006] Beban Pokok Penjualan', 'HPP', '[601] Harga Pokok Penjualan', '-');


#
# TABLE STRUCTURE FOR: mp_hutang
#

DROP TABLE IF EXISTS `mp_hutang`;

CREATE TABLE `mp_hutang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_hutang` varchar(128) NOT NULL,
  `tanggal_hutang` date NOT NULL,
  `penambahan` varchar(128) NOT NULL,
  `pengurangan` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# TABLE STRUCTURE FOR: mp_piutang
#

DROP TABLE IF EXISTS `mp_piutang`;

CREATE TABLE `mp_piutang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_piutang` varchar(128) NOT NULL,
  `tanggal_piutang` date NOT NULL,
  `penambahan` varchar(128) NOT NULL,
  `pengurangan` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# TABLE STRUCTURE FOR: mp_sub_entry
#

DROP TABLE IF EXISTS `mp_sub_entry`;

CREATE TABLE `mp_sub_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `accounthead` int(11) NOT NULL,
  `amount` int(128) NOT NULL,
  `type` int(1) NOT NULL,
  `journal_type` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sid` (`parent_id`),
  KEY `accounthead` (`accounthead`),
  KEY `amount` (`amount`),
  CONSTRAINT `mp_sub_entry_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `mp_generalentry` (`id`),
  CONSTRAINT `mp_sub_entry_ibfk_2` FOREIGN KEY (`accounthead`) REFERENCES `mp_head` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: supplier
#

DROP TABLE IF EXISTS `supplier`;

CREATE TABLE `supplier` (
  `id_supplier` int(11) NOT NULL AUTO_INCREMENT,
  `kode_supplier` varchar(10) DEFAULT NULL,
  `nama_supplier` varchar(50) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_supplier`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: transaksi
#

DROP TABLE IF EXISTS `transaksi`;

CREATE TABLE `transaksi` (
  `id_transaksi` int(11) NOT NULL AUTO_INCREMENT,
  `kode_transaksi` varchar(10) DEFAULT NULL,
  `tgl_transaksi` date DEFAULT NULL,
  `total_harga` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_transaksi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: user
#

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `email` varchar(128) NOT NULL,
  `image` varchar(128) NOT NULL,
  `password` varchar(256) NOT NULL,
  `role_id` int(11) NOT NULL,
  `is_active` int(1) NOT NULL,
  `date_created` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `user_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

INSERT INTO `user` (`id`, `name`, `email`, `image`, `password`, `role_id`, `is_active`, `date_created`) VALUES (3, 'Admin', 'admin@gmail.com', 'tiny-winny1.jpg', '$2y$10$S8ampsPXwlmsB3mo.Z9rHuG3gAg2ncZmDt.bX4MDD.MDWV1kYfOVO', 1, 1, 1642982363);
INSERT INTO `user` (`id`, `name`, `email`, `image`, `password`, `role_id`, `is_active`, `date_created`) VALUES (4, 'Keuangan', 'user@gmail.com', 'user_1696306891.png', '$2y$10$glei7WhvdN7ylPT2q83Ax.DQqKLeH2zwL99lvAcsvuwEET91X52GW', 2, 1, 1696307042);


#
# TABLE STRUCTURE FOR: user_access_menu
#

DROP TABLE IF EXISTS `user_access_menu`;

CREATE TABLE `user_access_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `menu_id` (`menu_id`),
  CONSTRAINT `user_access_menu_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`id`),
  CONSTRAINT `user_access_menu_ibfk_2` FOREIGN KEY (`menu_id`) REFERENCES `user_menu` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4;

INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (1, 1, 1);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (2, 1, 2);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (6, 1, 3);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (13, 2, 7);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (14, 2, 8);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (15, 2, 9);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (21, 1, 12);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (22, 2, 12);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (23, 2, 13);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (24, 2, 14);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (25, 1, 13);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (26, 1, 14);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (27, 1, 7);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (28, 1, 8);
INSERT INTO `user_access_menu` (`id`, `role_id`, `menu_id`) VALUES (29, 1, 9);


#
# TABLE STRUCTURE FOR: user_menu
#

DROP TABLE IF EXISTS `user_menu`;

CREATE TABLE `user_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;

INSERT INTO `user_menu` (`id`, `menu`) VALUES (1, 'Admin');
INSERT INTO `user_menu` (`id`, `menu`) VALUES (2, 'User');
INSERT INTO `user_menu` (`id`, `menu`) VALUES (3, 'Menu');
INSERT INTO `user_menu` (`id`, `menu`) VALUES (7, 'Data');
INSERT INTO `user_menu` (`id`, `menu`) VALUES (8, 'Akuntansi');
INSERT INTO `user_menu` (`id`, `menu`) VALUES (9, 'Laporan');
INSERT INTO `user_menu` (`id`, `menu`) VALUES (12, 'Persediaan');
INSERT INTO `user_menu` (`id`, `menu`) VALUES (13, 'Perhitungan');
INSERT INTO `user_menu` (`id`, `menu`) VALUES (14, 'Database');


#
# TABLE STRUCTURE FOR: user_role
#

DROP TABLE IF EXISTS `user_role`;

CREATE TABLE `user_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

INSERT INTO `user_role` (`id`, `role`) VALUES (1, 'Administrator');
INSERT INTO `user_role` (`id`, `role`) VALUES (2, 'Member');


#
# TABLE STRUCTURE FOR: user_sub_menu
#

DROP TABLE IF EXISTS `user_sub_menu`;

CREATE TABLE `user_sub_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `title` varchar(128) NOT NULL,
  `url` varchar(128) NOT NULL,
  `icon` varchar(128) NOT NULL,
  `is_active` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_id` (`menu_id`),
  CONSTRAINT `user_sub_menu_ibfk_1` FOREIGN KEY (`menu_id`) REFERENCES `user_menu` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4;

INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (1, 1, 'Dashboard', 'admin', 'fas fa-fw fa-tachometer-alt', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (3, 2, 'Edit Profil', 'user/edit', 'fas fa-fw fa-user-edit', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (4, 3, 'Menu Manajemen', 'menu', 'fas fa-fw fa-folder', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (5, 3, 'Submenu Manajemen', 'menu/submenu', 'fas fa-fw fa-folder-open', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (7, 1, 'Izin Akses', 'admin/role', 'fas fa-fw fa-user-tie', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (11, 7, 'Dashboard', 'dashboard', 'fas fa-fw fa-tachometer-alt', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (15, 8, 'Daftar Akun', 'accounts', 'fas fa-fw fa-list-ol', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (16, 8, 'Jurnal Umum', 'statements', 'fas fa-fw fa-swatchbook', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (17, 8, 'Buku Besar', 'statements/leadgerAccounst', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (18, 8, 'Neraca Saldo Awal', 'statements/trail_balance', 'fas fa-fw fa-balance-scale', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (19, 9, 'Neraca Keuangan', 'statements/balancesheet', 'fas fa-fw fa-chart-pie', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (20, 9, 'Laporan Laba Rugi', 'statements/income_statement', 'fas fa-fw fa-chart-bar', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (21, 8, 'Neraca Saldo Akhir', 'statements/trail_balance_final', 'fas fa-fw fa-balance-scale', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (22, 7, 'Daftar Hutang', 'data/hutang', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (23, 7, 'Daftar Piutang', 'data/piutang', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (24, 7, 'Daftar Aset', 'data', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (25, 13, 'Pajak Penghasilan', 'perhitungan', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (28, 14, 'Backup Database', 'database/take_backup', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (30, 12, 'Data Barang', 'barang', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (31, 12, 'Jenis Barang', 'jenis_barang', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (32, 12, 'Merk Barang', 'merk_barang', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (33, 12, 'Supplier Barang', 'supplier', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (34, 12, 'Transaksi Barang Masuk', 'barang_masuk', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (35, 12, 'Transaksi Barang Keluar', 'barang_keluar', 'fas fa-fw fa-book', 1);
INSERT INTO `user_sub_menu` (`id`, `menu_id`, `title`, `url`, `icon`, `is_active`) VALUES (37, 2, 'Data Pengguna', 'user', 'fa fa-user', 1);


SET foreign_key_checks = 1;
