<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Barang_masuk_model extends CI_Model
{

    public $table = 'barang_masuk';
    public $id = 'id_barang_masuk';
    public $order = 'DESC';

    function __construct()
    {
        parent::__construct();
    }

    // get all
    function get_all()
    {
        $this->db->order_by($this->id, $this->order);
        return $this->db->get($this->table)->result();
    }

    // get data by id
    function get_by_id($id)
    {
        $this->db->where($this->id, $id);
        return $this->db->get($this->table)->row();
    }
    
    // get total rows
    function total_rows($q = NULL) {
        $this->db->like('id_barang_masuk', $q);
	$this->db->or_like('kode_barang', $q);
	$this->db->or_like('kode_supplier', $q);
	$this->db->or_like('jumlah', $q);
	$this->db->or_like('harga', $q);
	$this->db->from($this->table);
        return $this->db->count_all_results();
    }

    // get data with limit and search
    function get_limit_data($limit, $start = 0, $q = NULL) {
        $this->db->order_by($this->id, $this->order);
        $this->db->like('id_barang_masuk', $q);
	$this->db->or_like('kode_barang', $q);
	$this->db->or_like('kode_supplier', $q);
	$this->db->or_like('jumlah', $q);
	$this->db->or_like('harga', $q);
	$this->db->limit($limit, $start);
        return $this->db->get($this->table)->result();
    }

    // insert data
    function insert($data)
    {
        $this->db->insert($this->table, $data);
    }

    // update data
    function update($id, $data)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->table, $data);
    }

    // delete data
    function delete($id)
    {
        $this->db->where($this->id, $id);
        $this->db->delete($this->table);
    }
    
    function cari($kode_barang){
        $this->db->select('*');
        $this->db->from('barang');
        $this->db->join('supplier', 'barang.kode_supplier = supplier.kode_supplier');
        $this->db->where('barang.kode_barang', $kode_barang);
        $query = $this->db->get();
        //$query= $this->db->get_where('barang',array('kode_barang'=>$kode_barang));
        return $query;
    }

}

