<?php
defined('BASEPATH') or exit('No direct script access allowed');

class User extends CI_Controller
{
	function __construct()
    {
        parent::__construct();
        $this->load->model('User_model');
    }

	//menghalangi masuk tanpa login
	public function index()
	{
		//Daftar User
		$data['title'] = 'Daftar Pengguna';
        $data['user'] = $this->db->get_where('user', ['email' => 
        $this->session->userdata('email')])->row_array();
        
        $start = 0;
        $user = $this->User_model->get_all();
        $data = array(
            'user' => $data['user'] ,
            'title' => $data['title'],
            'user_data' => $user,
            'start' => $start,
            'konten' => 'user/index',
        );
        
        $this->load->view('templates/header', $data);
            $this->load->view('templates/sidebar', $data);
            $this->load->view('templates/topbar', $data);
            $this->load->view('user/index', $data);
            $this->load->view('templates/footer');
    }
       //End Daftar User

	public function create() 
    {
        $data['title'] = 'Tambah Pengguna';
        $data['user'] = $this->db->get_where('user', ['email' => 
        $this->session->userdata('email')])->row_array();
        $data = array(
            'user' => $data['user'] ,
            'title' => $data['title'],
            'button' => 'Create',
            'action' => site_url('user/create_action'),
	    'id' => set_value('id'),
	    'name' => set_value('name'),
	    'email' => set_value('email'),
	    'password' => set_value('password'),
        'role_id' => set_value('role_id'),
        'is_active' => set_value('is_active'),
        'konten' => 'user/user_form',
            'judul' => 'Data Pengguna',
	);
        $this->load->view('templates/header', $data);
            $this->load->view('templates/sidebar', $data);
            $this->load->view('templates/topbar', $data);
            $this->load->view('user/user_form', $data);
            $this->load->view('templates/footer');
    }

    public function create_action() 
    {
        $data['user'] = $this->db->get_where('user', ['email' => 
        $this->session->userdata('email')])->row_array();
        $this->_rules();

        if ($this->form_validation->run() == FALSE) {
            $this->create();
        } else {

        $nmfile = "user_".time();
        $config['upload_path'] = 'assets/img/profile';
        $config['allowed_types'] = 'jpg|png|jpeg';
        $config['max_size'] = '20000';
        $config['file_name'] = $nmfile;
        // load library upload
        $this->load->library('upload', $config);
        // upload gambar 1
        $this->upload->do_upload('image');
        $result1 = $this->upload->data();
        $result = array('gambar'=>$result1);
        $dfile = $result['gambar']['file_name'];

            $data = array(
		'name' => $this->input->post('name',TRUE),
		'email' => $this->input->post('email',TRUE),
		'password' => password_hash($this->input->post('password',TRUE), PASSWORD_DEFAULT),
        'role_id' => $this->input->post('role_id',TRUE),
        'is_active' => $this->input->post('is_active',TRUE),
        'date_created' => time(),
		'image' => $dfile,
	    );

            $this->User_model->insert($data);
            $this->session->set_flashdata('message', 'Berhasil menambahkan Pengguna');
            redirect(site_url('user'));
        }
    }

    public function update($id) 
    {
        $data['title'] = 'Update Pengguna';
        $data['user'] = $this->db->get_where('user', ['email' => 
        $this->session->userdata('email')])->row_array();
        $row = $this->User_model->get_by_id($id);

        if ($row) {
            $data = array(
                'user' => $data['user'] ,
            'title' => $data['title'],
                'button' => 'Update',
                'action' => site_url('user/update_action'),
		'id' => set_value('id', $row->id),
		'name' => set_value('name', $row->name),
		'email' => set_value('email', $row->email),
		'password' => set_value('password'),
        'role_id' => set_value('role_id', $row->role_id),
        'is_active' => set_value('is_active', $row->is_active),
        'konten' => 'user/user_form',
            'judul' => 'Data Pengguna',
	    );
            $this->load->view('templates/header', $data);
            $this->load->view('templates/sidebar', $data);
            $this->load->view('templates/topbar', $data);
            $this->load->view('user/user_form', $data);
            $this->load->view('templates/footer');
        } else {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('user'));
        }
    }

    public function update_action() 
    {
        $data['user'] = $this->db->get_where('user', ['email' => 
        $this->session->userdata('email')])->row_array();
        $this->_rules();

        if ($this->form_validation->run() == FALSE) {
            $this->update($this->input->post('id', TRUE));
        } else {
        if(isset($_FILES['image']) && empty($_FILES['image']['name'])){
            
            $data = array(
        'name' => $this->input->post('name',TRUE),
        'email' => $this->input->post('email',TRUE),
        'password' => password_hash($this->input->post('password'), PASSWORD_DEFAULT),
        'role_id' => $this->input->post('role_id',TRUE),
        'is_active' => $this->input->post('is_active',TRUE),
        'date_created' => time(),
        );
            $data2 = array(
        'name' => $this->input->post('name',TRUE),
        'email' => $this->input->post('email',TRUE),
        'role_id' => $this->input->post('role_id',TRUE),
        'is_active' => $this->input->post('is_active',TRUE),
        'date_created' => time(),
        );
            if(isset($_POST['password']) && empty($_POST['password'])){
            	$this->User_model->update($this->input->post('id', TRUE), $data2);
            	$this->session->set_flashdata('message', 'Berhasil Update Pengguna');
            	redirect(site_url('user'));
            }else {
            	$this->User_model->update($this->input->post('id', TRUE), $data);
            	$this->session->set_flashdata('message', 'Berhasil Update Pengguna');
            	redirect(site_url('user'));
            }

        } else {

            $nmfile = "user_".time();
            $config['upload_path'] = 'assets/img/profile';
            $config['allowed_types'] = 'jpg|png|jpeg';
            $config['overwrite'] = TRUE;
            $config['max_size'] = '20000';
            $config['file_name'] = $nmfile;
            // load library upload
            $this->load->library('upload', $config);
            // upload gambar 1
            $this->upload->do_upload('image');
            $result1 = $this->upload->data();
            $result = array('gambar'=>$result1);
            $dfile = $result['gambar']['file_name'];

             $data = array(
        'name' => $this->input->post('name',TRUE),
        'email' => $this->input->post('email',TRUE),
        'password' => password_hash($this->input->post('password'), PASSWORD_DEFAULT),
        'role_id' => $this->input->post('role_id',TRUE),
        'is_active' => $this->input->post('is_active',TRUE),
        'date_created' => time(),
        'image' => $dfile,
        );
            $data2 = array(
        'name' => $this->input->post('name',TRUE),
        'email' => $this->input->post('email',TRUE),
        'role_id' => $this->input->post('role_id',TRUE),
        'is_active' => $this->input->post('is_active',TRUE),
        'date_created' => time(),
        'image' => $dfile,
        );

            if(isset($_POST['password']) && empty($_POST['password'])){
            	$this->User_model->update($this->input->post('id', TRUE), $data2);
            	$this->session->set_flashdata('message', 'Berhasil Update Pengguna');
            	redirect(site_url('user'));
            }else {
            	$this->User_model->update($this->input->post('id', TRUE), $data);
            	$this->session->set_flashdata('message', 'Berhasil Update Pengguna');
            	redirect(site_url('user'));
            }
        }

           
        }
    }

    public function delete($id) 
    {
        $data['user'] = $this->db->get_where('user', ['email' => 
        $this->session->userdata('email')])->row_array();
        $row = $this->User_model->get_by_id($id);

        if ($row) {
            $this->User_model->delete($id);
            $this->session->set_flashdata('message', 'Pengguna Berhasil dihapus');
            redirect(site_url('user'));
        } else {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('user'));
        }
    }

	public function edit()
	{
		$data['title'] = 'Edit Profile';
		$data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
		
		$this->form_validation->set_rules('name', 'Nama', 'required|trim');
		if($this->form_validation->run() == false)
		{
			//tampilkan view
			$this->load->view('templates/header', $data);
			$this->load->view('templates/sidebar', $data);
			$this->load->view('templates/topbar', $data);
			$this->load->view('user/edit', $data);
			$this->load->view('templates/footer');
		}
		else
		{
			$name = $this->input->post('name');
			$email = $this->input->post('email');

			//cek gambar
			$upload_image = $_FILES['image']['name'];

			if($upload_image)
			{
				$config['allowed_types']	= 'gif|jpg|png';
				$config['max_size']			= '2048';
				$config['upload_path']		= './assets/img/profile/';
				$this->load->library('upload', $config);

				if($this->upload->do_upload('image'))
				{
					$old_image = $data['user']['image'];
					if($old_image != 'default.jpg')
					{
						unlink(FCPATH. 'assets/img/profile/' . $old_image);
					}


					$new_image = $this->upload->data('file_name');
					$this->db->set('image', $new_image);
				}
				else
				{
					$this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">' . $this->upload->display_errors() . '</div>');
					redirect('user');
				}

			}

			$this->db->set('name', $name);
			$this->db->where('email', $email);
			$this->db->update('user');
			$this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Profil telah diubah</div>');
			redirect('user');
		}
		
	}
	public function edit2()
	{
		$data['title'] = 'Edit Email';
		$data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
		$this->form_validation->set_rules('email', 'Email', 'required|trim');
		$this->form_validation->set_rules('name', 'Nama', 'required|trim');

		if($this->form_validation->run() == false)
		{
			//tampilkan view
			$this->load->view('templates/header', $data);
			$this->load->view('templates/sidebar', $data);
			$this->load->view('templates/topbar', $data);
			$this->load->view('user/editemail', $data);
			$this->load->view('templates/footer');
		}
		else
		{
			$name = $this->input->post('name');
			$email = $this->input->post('email');

			



			$this->db->set('email', $email);
			$this->db->where('name', $name);
			$this->db->update('user');
			redirect('auth/logout');
		}
		
	}

	public function edit3()
	{
		$data['title'] = 'Edit Nama Pengguna';
		$data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
		$this->form_validation->set_rules('email', 'Email', 'required|trim');
		$this->form_validation->set_rules('name', 'Nama', 'required|trim');

		if($this->form_validation->run() == false)
		{
			//tampilkan view
			$this->load->view('templates/header', $data);
			$this->load->view('templates/sidebar', $data);
			$this->load->view('templates/topbar', $data);
			$this->load->view('user/editnama', $data);
			$this->load->view('templates/footer');
		}
		else
		{
			$name = $this->input->post('name');
			$email = $this->input->post('email');

			



			$this->db->set('name', $name);
			$this->db->where('email', $email);
			$this->db->update('user');
			redirect('dashboard');
		}
		
	}

	public function edit4()
	{
		$data['title'] = 'Edit Nama Usaha';
		$data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
		$data['user_company'] = $this->db->get_where('user_company')->row_array();
		$this->form_validation->set_rules('id', 'Id', 'required|trim');
		$this->form_validation->set_rules('name', 'Name', 'required|trim');
$this->form_validation->set_rules('loc', 'Loc', 'required|trim');
		if($this->form_validation->run() == false)
		{
			//tampilkan view
			$this->load->view('templates/header', $data);
			$this->load->view('templates/sidebar', $data);
			$this->load->view('templates/topbar', $data);
			$this->load->view('user/editusaha', $data);
			$this->load->view('templates/footer');
		}
		else
		{
			$name = $this->input->post('name');
$loc = $this->input->post('loc');
			



			$this->db->set('name', $name);
			$this->db->where('loc', $loc);
			$this->db->update('user_company');
			redirect('dashboard');
		}
		
	}


	public function changePassword()
	{
		$data['title'] = 'Ubah Password';
		$data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

		$this->form_validation->set_rules('current_password', 'Current Password', 'required|trim');
		$this->form_validation->set_rules('new_password1', 'New Password', 'required|trim|matches[new_password2]');
		$this->form_validation->set_rules('new_password2', 'Confirm New Password', 'required|trim|matches[new_password1]');

	if($this->form_validation->run() == false){
		//tampilkan view
		$this->load->view('templates/header', $data);
		$this->load->view('templates/sidebar', $data);
		$this->load->view('templates/topbar', $data);
		$this->load->view('user/changepassword', $data);
		$this->load->view('templates/footer');
	}
	else
	{
		$current_password = $this->input->post('current_password');
		$new_password = $this->input->post('new_password1');
		if (!password_verify
			($current_password, $data['user']['password'])
		)
		{
			$this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Salah</div>');
			redirect('user/changepassword');
		}
		else
		{
			if($current_password == $new_password)
			{
				$this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Tidak Boleh Sama</div>');
				redirect('user/changepassword');
			}
			else
			{
				$password_hash = password_hash($new_password, PASSWORD_DEFAULT);
				$this->db->set('password', $password_hash);
				$this->db->where('email', $this->session->userdata('email'));
				$this->db->update('user');
				$this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Berhasil</div>');
				redirect('auth/logout');
			}
		}
	}
	}

	public function _rules() 
    {
	$this->form_validation->set_rules('name', 'Nama Lengkap', 'trim|required');
	$this->form_validation->set_rules('email', 'Email', 'trim|required');
	//$this->form_validation->set_rules('password', 'Password', 'trim|required');
	$this->form_validation->set_rules('role_id', 'Hak Akses', 'trim|required');
	$this->form_validation->set_rules('is_active', 'Status', 'trim|required');

	$this->form_validation->set_rules('id', 'id', 'trim');
	$this->form_validation->set_error_delimiters('<span class="text-danger">', '</span>');
    }
}